<?php 
session_start();

require("config/conn.php");
require("functions.php");
include("includes/header.php");
include("includes/topbar.php");
include("includes/sidebar.php");

session_regenerate_id(true);

if (!isset($_SESSION['AdminLoginId'])) {
    header("Location: index.php");
} 
?>



<main>
    <div class="container-fluid px-4">

        <h1 class="mt-4 dash-heading">Withdraw Requests</h1>
        <ol class="breadcrumb mb-4">
            <li class="breadcrumb-item active">Withdraw Requests</li>
        </ol>




        <div class="row mb-4">

            <div class="user-table">

                <div class="useractioncontainer d-flex align-items-center justify-content-end">

                    <div class="dropdown">
                        <a class="download-data-btn dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown"
                            aria-expanded="false">
                            Download
                        </a>

                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="export.php?export_games_csv=true">CSV</a></li>
                            <li><a class="dropdown-item" href="export.php?export_games_excel=true" >Excel</a>
                            </li>
                        </ul>
                    </div>
                </div>
                <form method="post" id="frm">
                    <table id="example" class="table table-striped" style="width:100%">
                        <thead>
                            <tr>
                                <th>SR No.</th>
                               
                                <th>UId</th>
                                <th>Method</th>
                                <th>Method Id</th>
                                <th>Amount</th>
                                <th>Coins</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
            
            $sql = "SELECT * FROM `withdrawrequests` ORDER BY `status` ASC";

            $query_run = mysqli_query($conn, $sql);

            if ($query_run):
                if (mysqli_num_rows($query_run) > 0):

                    $i = 1;

                    foreach ($query_run as $row):

                        if ($row['status'] == 1):
                            $text = "Paid";
                            $style = "active";
                        elseif($row['status'] == 0):
                            $text = "Unpaid";
                            $style = "banned";
                        else:
                            $text = "Rejected";
                            $style = "banned";
                        
                        endif;
                        ?>



                            <tr id="box<?= $row['id']; ?>">
                                 <td>
                                    <?= $i; ?>
                                </td>
                            
                                <td>
                                    <?= $row['uId'] ?>
                                </td>
                                <td>
                                    <?= $row['method'] ?>
                                </td>
                                <td>
                                    <?= $row['methodId'] ?>
                                </td>
                                <td>
                                    <?= $row['amount'] ?>
                                </td>
                                <td>
                                    <?= $row['coins'] ?>
                                </td>
                                <td class="d-flex align-items-center"><span class="<?= $style; ?>">
                                        <?= $text ?>
                                    </span></td>
                    </td>
                                <td> 
                                    <div class="d-flex align-items-center">
                                        <?php
                                        
                                        if ($row['status'] == 1):
                                            
                                        
                                        elseif($row['status'] == 0):
                                        ?>

                                <a href="code.php?withdraw_id=<?= $row['id']; ?>" class="pay-button">Pay</a>
                                <div class="form">
                                    <form action="code.php" method="post">
                                        <input type="hidden" name="coins" value="<?= $row['coins']; ?>">
                                        <input type="hidden" name="id" value="<?= $row['id']; ?>">
                                        <input type="hidden" name="id_withdraw"
                                        value="<?= $row['uId']; ?>">
                                        <button class="reject" name="rejectRequest" >Reject</button>
                                    </form>
                                </div>

<?php

                                        else:
                                        endif;

                                        
                                        ?>
                                   
                                    </div>
                                </td>
                            </tr>


                            <?php

                        $i++;
                    endforeach;








                else:
                    echo "No Category Data";
                endif;
            else:
                echo "Some Error Occured";
            endif;
            
            
            
            ?>

                        </tbody>
                    </table>
                </form>


            </div>
        </div>




<!-- Modal -->
<div class="modal fade" id="editGame" tabindex="-1" aria-labelledby="editGameLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h1 class="modal-title fs-5" id="editGameLabel">Edit Game</h1>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
          <form action="code.php" method="POST" enctype="multipart/form-data">
              <div class="mb-3">
                  <label for="catLabel" class="form-label">Icon</label>
                    <div class="img-container d-flex justify-content-center align-items-center mb-4">
                        <img alt="icon" id="icon" style="width: 100px; height: 100px;">
                    </div>
                  <input  type="file" class="form-control" id="game_image" class="game_image" name="game_image">
                  <input type="hidden" class="oldImage" name="oldImage">
                  <input type="hidden" class="id" name="id">
                </div>
              <div class="mb-3">
                  <label for="catLabel" class="form-label">Background Image</label>
                    <div class="img-container d-flex justify-content-center align-items-center mb-4">
                        <img alt="bgImage" id="bgImage" style="width: 100px; height: 100px;">
                    </div>
                  <input  type="file" class="form-control" id="bg_image" class="bg_image" name="bg_image">
                  <input type="hidden" class="bg-image" name="old-bg-image">
                 
                </div>
              <div class="mb-3">
                  <label for="catLabel" class="form-label">Title</label>
                  <input required type="text" class="form-control" id="game_name" name="game_name" class="game_name">
                </div>
              <div class="mb-3">
                  <label for="catLabel" class="form-label">Url</label>
                  <input required type="text" class="form-control" id="url" name="url" class="url">
                </div>
                <div class="mb-3 ">
                        <label for="title" class="form-label">Select Color</label>
                        <div class="d-flex align-items-center flex-wrap">
                        <div class="form-check">
                            <input class="c-1 form-check-input" name="color" type="radio" value="1" id="color">
                            <label class="form-check-label" style="background: #E9E7FF; width: 20px; height: 20px;" for="radio">
                                
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="c-2 form-check-input" name="color" type="radio" value="2" id="color">
                            <label class="form-check-label" style="background: #DAE8FF; width: 20px; height: 20px;" for="radio">
                                
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="c-3 form-check-input" name="color" type="radio" value="3" id="color">
                            <label class="form-check-label" style="background: #FFDEDE; width: 20px; height: 20px;" for="radio">
                                
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="c-4 form-check-input" name="color" type="radio" value="4" id="color">
                            <label class="form-check-label" style="background: #FFF7E0; width: 20px; height: 20px;" for="radio">
                                
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="c-5 form-check-input" name="color" type="radio" value="5" id="color">
                            <label class="form-check-label" style="background: #FDD3E7; width: 20px; height: 20px;" for="radio">
                                
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="c-6 form-check-input" name="color" type="radio" value="6" id="color">
                            <label class="form-check-label" style="background: #F7EAFF; width: 20px; height: 20px;" for="radio">
                                
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="c-7 form-check-input" name="color" type="radio" value="7" id="color">
                            <label class="form-check-label" style="background: #E0FCF9; width: 20px; height: 20px;" for="radio">
                                
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="c-8 form-check-input" name="color" type="radio" value="8" id="color">
                            <label class="form-check-label" style="background: #FEEFED; width: 20px; height: 20px;" for="radio">
                                
                            </label>
                        </div>
</div>

</div>
                
<button class="add-category-btn edit-categpory-btn" name="edit_game" type="submit">Save</button>

            </form>
        </div>
        <div class="modal-footer">
           
        </div>
    </div>
</div>
</div>



    </div>


     <!-- Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h1 class="modal-title fs-5" id="deleteModalLabel">Delete Category</h1>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
    </div>
    <form action="code.php" method="post">
      <div class="modal-body">
        <p>Are you sure to delete this category ?</p>
        <input type="hidden" name="del_id" class="delete-game-id" id="del_id">
      </div>
      <div class="modal-footer d-flex justify-content-start">

        <button type="submit" class="btn btn-primary delButton" name="delGames">Yes! Delete</button>
    </div>
</form>
    </div>
  </div>
</div>


</main>









<?php 

include("includes/script.php");

?>


<script>
    <?php

    if (isset($_SESSION['status'])) {
    ?>
            swal("<?= $_SESSION['message']; ?>", {
                icon: "<?= $_SESSION['icon'] ?>",

            }
            );
    <?php
  unset($_SESSION['status']);
        unset($_SESSION['message']);
        unset($_SESSION['icon']);
    }

?>


</script>


<script>
        $(document).ready(function () {
            var table = $('#example').DataTable({
                language: {
                    searchPlaceholder: "Search Category"
                },
                columnDefs: [
                    {
                        targets: 0,
                        checkboxes: {
                            selectRow: true
                        }
                    }
                ],
                select: {
                    style: 'multi'
                },
                order: [[1, 'asc']]

            });

        });



</script>
<script>





    function select_all() {
        if (jQuery('#delete').prop("checked")) {
            jQuery('input[type=checkbox]').each(function (param) {
                jQuery('#' + this.id).prop('checked', true);
                // console.log(this.id);
            });
        } else {
            jQuery('input[type=checkbox]').each(function (param) {
                jQuery('#' + this.id).prop('checked', false);
                // console.log(this.id);
            });
        }

    }




    function delete_all() {

        swal({
            title: "Change Status",
            text: "Want to Pay or reject!",
            icon: "success",
            buttons: ["Reject", "Pay"],
            dangerMode: true,
        })
            .then((willDelete) => {
                if (willDelete) {
                    jQuery.ajax({
                        type: "post",
                        url: "code.php",
                        data: jQuery("#frm").serialize(),
                        success: function (response) {

                            jQuery('input[type=checkbox]').each(function () {
                                if (jQuery('#' + this.id).prop("checked")) {
                                    jQuery('#box' + this.id).remove();
                                }
                                swal({
                                    title: "Categories Deleted Successfully",
                                    text: "Categories Deleted",
                                    icon: "success",
                                });
                            });
                        }
                    });
                } else {

                }
            });



    }
</script>

<script>
    $('.edit-btn').click(function (e) { 
        e.preventDefault();

        var game_id = $(this).closest('tr').find('.game_id').text();
        // console.log(cat_id);
        $.ajax({
            type: "POST",
            url: "code.php",
            data: {
                'checking_edit_games_btn': true,
                'game_id': game_id,
            },
            success: function (response) {
                // console.log(response);
                $.each(response, function (key, value) { 
                    // console.log(value['name']);
                    $("#game_name").val(value['name']);
                    $(".oldImage").val(value['icon']);
                    $(".bg-image").val(value['bgImage']);
                    $(".id").val(value['id']);
                    $("#url").val(value['gameUrl']);
                    $("#icon").attr('src', value['icon']);
                    $("#bgImage").attr('src', value['bgImage']);
                    


                   
                });
                


                $('#editGame').modal('show');
            }
        });
        
    });
</script>

<script>
    $(document).ready(function () {
        $('.delete-game').click(function (e) {
            e.preventDefault();

            var id = $(this).val();
            // console.log(user_id);
            $('.delete-game-id').val(id);
            $('#deleteModal').modal('show')
        });
    });

</script>

<?php

include("includes/footer.php");


?>